<?php
// Simple error reporting script for diagnosing 500 errors
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>PHP Environment Test</h1>";

// PHP Version
echo "<p>PHP Version: " . phpversion() . "</p>";

// Check if session works
echo "<p>Session test: ";
session_start();
$_SESSION['test'] = 'Working';
echo isset($_SESSION['test']) ? "Working" : "Failed";
echo "</p>";

// Check database connection
echo "<h2>Database Connection Test</h2>";
echo "<p>Attempting to connect to database...</p>";

try {
    // Use a simple mysqli connection without using the config.php
    $host = 'localhost';
    $user = 'nsaorg_mobileapp';
    $pass = '.com/iisADMIN123';
    $dbname = 'nsaorg_mobileapp';
    
    $conn = new mysqli($host, $user, $pass, $dbname);
    
    if ($conn->connect_error) {
        echo "<p style='color:red'>Connection failed: " . $conn->connect_error . "</p>";
    } else {
        echo "<p style='color:green'>Database connection successful!</p>";
        
        // Try a simple query
        echo "<p>Testing query: ";
        $result = $conn->query("SHOW TABLES");
        if ($result) {
            echo "Success! Found " . $result->num_rows . " tables:</p>";
            echo "<ul>";
            while ($row = $result->fetch_array()) {
                echo "<li>" . htmlspecialchars($row[0]) . "</li>";
            }
            echo "</ul>";
        } else {
            echo "Query failed: " . $conn->error . "</p>";
        }
        
        $conn->close();
    }
} catch (Exception $e) {
    echo "<p style='color:red'>Error: " . $e->getMessage() . "</p>";
}

echo "<h2>Environment Variables</h2>";
echo "<pre>";
print_r($_SERVER);
echo "</pre>";

echo "<p><a href='index.php'>Try accessing the dashboard</a></p>";
?>