<?php
// Simple index file with error reporting to diagnose issues
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Auto-login for testing
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'admin';
$_SESSION['role'] = 'admin';

// Display a basic dashboard
echo "<!DOCTYPE html>
<html>
<head>
    <title>NSA Dashboard</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body>
    <div class='container mt-5'>
        <div class='alert alert-success'>
            <h3>Dashboard Access Successful!</h3>
            <p>You've successfully bypassed authentication and accessed the dashboard.</p>
        </div>
        <div class='card'>
            <div class='card-header'>
                <h4>Next Steps</h4>
            </div>
            <div class='card-body'>
                <p>Now that basic access is working, you can:</p>
                <ol>
                    <li>Examine the server logs for specific errors in the full dashboard</li>
                    <li>Check database connection and permissions</li>
                    <li>Incrementally add back functionality from your original dashboard</li>
                </ol>
                <a href='test.php' class='btn btn-primary'>Run Diagnostic Test</a>
            </div>
        </div>
    </div>
</body>
</html>";
?>