<?php
// Database configuration
$config = [
    'db_host' => 'localhost', // Most cPanel setups use localhost
    'db_user' => 'nsaorg_mobileapp',
    'db_pass' => '.com/iisADMIN123',
    'db_name' => 'nsaorg_mobileapp',
    'app_name' => 'NSA Admin Dashboard',
    'app_version' => '1.0.0',
];

// Function to create a database connection
function connect_db() {
    global $config;
    
    $conn = new mysqli(
        $config['db_host'], 
        $config['db_user'], 
        $config['db_pass'], 
        $config['db_name']
    );
    
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    // Set charset to ensure proper encoding
    $conn->set_charset("utf8mb4");
    
    return $conn;
}

// Function to sanitize input data
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

// Function to log actions - simplified to avoid file system errors
function log_action($action, $details = '') {
    // Skip logging to prevent file permission issues
    // This is a temporary solution until proper permissions are set up
    return;
}

// Start the session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

// Redirect if not logged in
function require_login() {
    // TEMPORARY: Auto-login as admin for testing purposes
    if (!is_logged_in()) {
        // Set session variables to simulate admin login
        $_SESSION['user_id'] = 1;
        $_SESSION['username'] = 'admin';
        $_SESSION['role'] = 'admin';
        // No redirect - allow access
    }
}

// Get current user ID
function get_current_user_id() {
    return $_SESSION['user_id'] ?? null;
}

// Function to get pagination HTML
function get_pagination($total_pages, $current_page, $base_url) {
    $html = '<nav aria-label="Page navigation"><ul class="pagination justify-content-center">';
    
    // Previous button
    $prev_disabled = ($current_page <= 1) ? 'disabled' : '';
    $html .= '<li class="page-item ' . $prev_disabled . '">';
    $html .= '<a class="page-link" href="' . $base_url . '&page=' . ($current_page - 1) . '" tabindex="-1">Previous</a>';
    $html .= '</li>';
    
    // Page numbers
    $start = max(1, $current_page - 2);
    $end = min($total_pages, $current_page + 2);
    
    if ($start > 1) {
        $html .= '<li class="page-item"><a class="page-link" href="' . $base_url . '&page=1">1</a></li>';
        if ($start > 2) {
            $html .= '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
    }
    
    for ($i = $start; $i <= $end; $i++) {
        $active = ($i == $current_page) ? 'active' : '';
        $html .= '<li class="page-item ' . $active . '"><a class="page-link" href="' . $base_url . '&page=' . $i . '">' . $i . '</a></li>';
    }
    
    if ($end < $total_pages) {
        if ($end < $total_pages - 1) {
            $html .= '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }
        $html .= '<li class="page-item"><a class="page-link" href="' . $base_url . '&page=' . $total_pages . '">' . $total_pages . '</a></li>';
    }
    
    // Next button
    $next_disabled = ($current_page >= $total_pages) ? 'disabled' : '';
    $html .= '<li class="page-item ' . $next_disabled . '">';
    $html .= '<a class="page-link" href="' . $base_url . '&page=' . ($current_page + 1) . '">Next</a>';
    $html .= '</li>';
    
    $html .= '</ul></nav>';
    
    return $html;
}