<?php
// Basic index file with minimal functionality
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Start session at the beginning to avoid errors
session_start();

// Auto-login
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'admin';
$_SESSION['role'] = 'admin';

// Database connection
$config = [
    'db_host' => 'localhost',
    'db_user' => 'nsaorg_mobileapp',
    'db_pass' => '.com/iisADMIN123',
    'db_name' => 'nsaorg_mobileapp'
];

// Connect to database
$conn = new mysqli(
    $config['db_host'],
    $config['db_user'],
    $config['db_pass'],
    $config['db_name']
);

// Initialize stats and arrays
$stats = [
    'reports_count' => 0,
    'categories_count' => 0,
    'indicators_count' => 0,
    'themes_count' => 0,
    'users_count' => 0
];
$recent_reports = [];
$recent_indicators = [];

// Get basic stats if connection succeeds
if (!$conn->connect_error) {
    try {
        // Get table counts for all tables that might exist
        $tables_to_check = [
            'reports' => 'reports_count',
            'report_categories' => 'categories_count',
            'national_indicators' => 'indicators_count',
            'indicator_themes' => 'themes_count',
            'users' => 'users_count'
        ];
        
        foreach ($tables_to_check as $table => $stat_key) {
            $check = $conn->query("SHOW TABLES LIKE '$table'");
            if ($check && $check->num_rows > 0) {
                $result = $conn->query("SELECT COUNT(*) as count FROM $table");
                if ($result && $row = $result->fetch_assoc()) {
                    $stats[$stat_key] = $row['count'];
                }
            }
        }
        
        // Get recent reports (safely checking table structure)
        $table_check = $conn->query("SHOW TABLES LIKE 'reports'");
        if ($table_check && $table_check->num_rows > 0) {
            // Check column names
            $columns = [];
            $result = $conn->query("SHOW COLUMNS FROM reports");
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $columns[$row['Field']] = true;
                }
            }
            
            // Get report data based on available columns
            $id_field = array_key_exists('id', $columns) ? 'id' : 
                       (array_key_exists('report_id', $columns) ? 'report_id' : 'id');
            $title_field = array_key_exists('title', $columns) ? 'title' : 
                          (array_key_exists('report_title', $columns) ? 'report_title' : 'title');
            
            $query = "SELECT $id_field as id, $title_field as title FROM reports ORDER BY $id_field DESC LIMIT 5";
            $result = $conn->query($query);
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $recent_reports[] = $row;
                }
            }
        }
        
        // Get recent indicators (safely checking table structure)
        $table_check = $conn->query("SHOW TABLES LIKE 'national_indicators'");
        if ($table_check && $table_check->num_rows > 0) {
            $query = "SELECT indicator_id, indicator_name, value FROM national_indicators ORDER BY indicator_id DESC LIMIT 5";
            $result = $conn->query($query);
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $recent_indicators[] = $row;
                }
            }
        }
    } catch (Exception $e) {
        // Log error but continue
        error_log("Database query error: " . $e->getMessage());
    }
    
    // Close connection
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NSA Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-10 offset-md-1">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0">NSA Admin Dashboard</h4>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-success">
                            <h5>Login Successful!</h5>
                            <p>You are now logged in as <strong>admin</strong>.</p>
                        </div>
                        
                        <h5 class="mb-4">Dashboard Statistics</h5>
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <i class="fas fa-file-alt fs-3 text-primary mb-2"></i>
                                        <h5 class="card-title">Reports</h5>
                                        <p class="card-text fs-4 fw-bold"><?php echo number_format($reports_count); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <i class="fas fa-tags fs-3 text-success mb-2"></i>
                                        <h5 class="card-title">Categories</h5>
                                        <p class="card-text fs-4 fw-bold"><?php echo number_format($categories_count); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-light">
                                    <div class="card-body text-center">
                                        <i class="fas fa-chart-line fs-3 text-info mb-2"></i>
                                        <h5 class="card-title">Indicators</h5>
                                        <p class="card-text fs-4 fw-bold"><?php echo number_format($indicators_count); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <h5 class="mb-3">Quick Links</h5>
                        <div class="list-group mb-4">
                            <a href="test.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-check-circle me-2 text-success"></i> Diagnostic Test Page
                            </a>
                            <a href="simple_index.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-home me-2 text-primary"></i> Simple Dashboard
                            </a>
                        </div>
                        
                        <div class="text-center mt-4">
                            <p class="text-muted">NSA Admin Dashboard &copy; <?php echo date('Y'); ?> Namibia Statistics Agency</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>